/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: BaseDialog.h $
   Last Modification:
    $Author: MichaelT $
    $Modtime: 30.06.06 15:20 $
    $Revision: 436 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
       
   Changes:
    Base dialog for all pages. Overrides PreTranslateMessage to prevent closing by keypress
    and creates a cyclic thread if neccessary
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      1        29.06.2006  MT       initial version
 
**************************************************************************************/

///////////////////////////////////////////////////////////////////////////////////////////
///  \file BaseDialog.h
///   Base dialog for all pages. Overrides PreTranslateMessage to prevent closing by keypress
///   and creates a cyclic thread if neccessary
///////////////////////////////////////////////////////////////////////////////////////////

#pragma once
#include "afxwin.h"

class CCifXDeviceBase;

///////////////////////////////////////////////////////////////////////////////////////////
/// Base dialog for all pages. Overrides PreTranslateMessage to prevent closing by keypress
/// and creates a cyclic thread if neccessary
///////////////////////////////////////////////////////////////////////////////////////////
class CBaseDialog : public CDialog
{
  DECLARE_DYNAMIC(CBaseDialog)

public:
  CBaseDialog(UINT uiIDD, CWnd* pcParent = NULL, bool fEnableThread = true, unsigned long ulThreadTimeout = 10);
  virtual ~CBaseDialog(void);

  BOOL PreTranslateMessage(MSG* pMsg);
  virtual BOOL OnInitDialog();

  virtual void        ThreadFunction(void) = 0;
  virtual void        OnUpdateDevice(CCifXDeviceBase* pcDevice) = 0;

  void SetThreadTimeout(unsigned long ulNewTimeout) { m_ulThreadTimeout = ulNewTimeout; }
  void SetThreadState(bool fEnable)                 { m_fThreadActive = fEnable;        }

  unsigned long     m_ulThreadTimeout;

protected:
  DECLARE_MESSAGE_MAP()

private:
  static DWORD WINAPI CyclicThreadStub(LPVOID pvParam);
  void                CyclicThread(void);

  HANDLE            m_hThreadStop;        //!< Event to stop the cyclic thread
  HANDLE            m_hCyclicThread;      //!< Handle to the cyclic thread
  bool              m_fThreadActive;      //!< true if the thread is currently running
  bool              m_fCreateThread;      //!< true if a thread was requested by constructor
};
